package gov.va.genisis2.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dao.IStudyApprovalDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.service.IStudyApprovalService;
import gov.va.genisis2.util.Helper;

/**
 * The Class StudyApprovalServiceTest.
 *
 * @author Getaneh Kassahun
 * 
 *         The Class StudyApprovalServiceTest.
 * 
 *         Description: In this StudyApprovalServiceTest Class which extends the
 *         abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class StudyApprovalServiceTest extends AbstractMockMvcTests {

	/** The LOGGER. */
	private static final Logger logger = LoggerFactory.getLogger(StudyApprovalServiceTest.class);

	@Autowired
	private IStudyApprovalService studyApprovalService;

	@Autowired
	private IStudyApprovalDao studyApprovalDao;

	/**
	 * Test create study approval null.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 */
	@Test
	@Ignore
	public void test1CreateStudyApproval_Null1() throws GenisisServiceException {

		logger.info("**********Junit Test Create Study Approval Null**********");
		Assert.assertEquals(0, studyApprovalService.createStudyApproval(null));

	}

	/**
	 * Test create study approval not null.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 */
	@Test
	@Ignore
	public void test2CreateStudyApproval_notNull() throws GenisisServiceException {

		logger.info("**********JunitTest Create Study Approval Not Null**********");
		Assert.assertTrue(studyApprovalService.createStudyApproval(Helper.getNewStudyApproval()) > 175);

	}

	/**
	 * Test get study approval by id.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 */
	@Test
	@Ignore
	public void test3GetStudyApprovalById() throws GenisisServiceException {

		logger.info("**********Junit Test Get Study Approval By Id**********");
		Assert.assertNotNull((StudyApproval) studyApprovalService.getStudyApprovalsByID(176));

	}

	/**
	 * Test get study approval by UID.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 */
	@Test
	@Ignore
	public void test4GetStudyApprovalByUID() throws GenisisServiceException {

		logger.info("**********Junit Test Study Approval By UID**********");
		List<StudyApproval> listOfstudyApproval = studyApprovalService.getStudyApprovalsByUID("researcher1");
		Assert.assertNotNull(listOfstudyApproval);
	}

	/**
	 * Test get study approval.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 */
	@Test
	@Ignore
	public void test5GetStudyApproval() throws GenisisServiceException {

		logger.info("**********Junit Test Study Approval By UID**********");
		List<StudyApproval> listOfstudyApproval = studyApprovalService.getStudyApprovals();
		Assert.assertNotNull(listOfstudyApproval);
	}

	/**
	 * Test update study approval.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 */
	@Test
	@Ignore
	public void test6UpdateStudyApproval() throws GenisisServiceException, GenisisDAOException {

		logger.info("**********Junit Test Update Study Approval**********");
		StudyApproval studyApproval = studyApprovalService.getStudyApprovalsByID(176);
		assertNotNull(studyApproval);
		assertEquals(176, studyApproval.getId());
		studyApproval.setTitle("Test update study approval");
		// Assert.assertEquals(176,
		 //studyApprovalDao.updateStudyApproval(studyApproval);
	}

	/**
	 * Test update study approval.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 */
	@Test
	@Ignore
	public void test7UpdateStudyApproval() throws GenisisDAOException, GenisisServiceException {

		logger.info("**********Junit Test Update Study Approval with Id 0**********");
		StudyApproval studyApproval = studyApprovalDao.getStudyApprovalsByID(178);
		assertNotNull(studyApproval);
		assertEquals(178, studyApproval.getId());
		studyApproval.setId(0);
		Assert.assertEquals(0, studyApprovalService.updateStudyApproval(studyApproval));
	}
}
